/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com				
*/

var STBGlobalTableResponsive = Object.create(STBModule.prototype);

STBGlobalTableResponsive.name = "GlobalTableResponsive";

STBGlobalTableResponsive.initPlugin = function() {

	var elements = $("table:not(.__done)");

	if (elements.length) {
		elements.each(function() {
			var table = $(this),
				header = table.find("thead tr > th"),
				headers = [],
				body = table.find("tbody > tr");

			if (header.length){

				header.each(function() {
					headers.push($(this).text().trim());
				});
			}

			if (body.length) {
				body.each(function() {
					var td = $(this).find("td"),
						i = 0;

					if (td.length == headers.length) {
						i = 0;
						td.each(function() {
							$(this).attr("data-th" , headers[i++]);
						});
					}
				});
			}
		});

		elements.addClass("__done");
	}
}

STBGlobalTableResponsive.runOnReady = function()  {
	STBGlobalTableResponsive.initPlugin();
}

STBGlobalTableResponsive.runOnContentUpdate = function()  {
	STBGlobalTableResponsive.initPlugin();
}

site.registerModule(STBGlobalTableResponsive);